/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.ActionBase;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScanJump
extends ActionBase {
    private static final Logger log = Logger.getLogger(ScanJump.class.getName());
    public static final String PARAMETER_BEHAVIOUR = "Behaviour";
    private static final String DEFAULT_BEHAVIOUR = "";
    public static final String PARAMETER_TARGETBEHAVIOUR = "TargetBehaviour";
    private static final String DEFAULT_TARGETBEHAVIOUR = "";
    public static final String PARAMETER_TARGETLOOK = "TargetLook";
    private static final boolean DEFAULT_TARGETLOOK = false;
    public static final String PARAMETER_VELOCITY = "VelocityParam";
    private static final double DEFAULT_VELOCITY = 20.0;
    public static final String VARIABLE_VELOCITYX = "VelocityX";
    public static final String VARIABLE_VELOCITYY = "VelocityY";
    private WeakReference<Mascot> target;

    public ScanJump(ResourceBundle schema, List<Animation> animations, VariableMap params) {
        super(schema, animations, params);
    }

    @Override
    public void init(Mascot mascot) throws VariableException {
        super.init(mascot);
        this.getMascot().getAffordances().clear();
        if (this.getMascot().getManager() != null) {
            this.target = this.getMascot().getManager().getMascotWithAffordance(this.getAffordance());
        }
        this.putVariable(this.getSchema().getString("TargetX"), this.target != null && this.target.get() != null ? Integer.valueOf(((Mascot)this.target.get()).getAnchor().x) : null);
        this.putVariable(this.getSchema().getString("TargetY"), this.target != null && this.target.get() != null ? Integer.valueOf(((Mascot)this.target.get()).getAnchor().y) : null);
    }

    @Override
    public boolean hasNext() throws VariableException {
        if (this.getMascot().getManager() == null) {
            return super.hasNext();
        }
        return super.hasNext() && this.target != null && this.target.get() != null && ((Mascot)this.target.get()).getAffordances().contains(this.getAffordance());
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        this.getMascot().getAffordances().clear();
        int targetX = ((Mascot)this.target.get()).getAnchor().x;
        int targetY = ((Mascot)this.target.get()).getAnchor().y;
        this.putVariable(this.getSchema().getString("TargetX"), targetX);
        this.putVariable(this.getSchema().getString("TargetY"), targetY);
        if (this.getMascot().getAnchor().x != targetX) {
            this.getMascot().setLookRight(this.getMascot().getAnchor().x < targetX);
        }
        double distanceX = targetX - this.getMascot().getAnchor().x;
        double distanceY = (double)(targetY - this.getMascot().getAnchor().y) - Math.abs(distanceX) / 2.0;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        double velocity = this.getVelocity();
        if (distance != 0.0) {
            int velocityX = (int)(velocity * distanceX / distance);
            int velocityY = (int)(velocity * distanceY / distance);
            this.putVariable(this.getSchema().getString(VARIABLE_VELOCITYX), velocity * distanceX / distance);
            this.putVariable(this.getSchema().getString(VARIABLE_VELOCITYY), velocity * distanceY / distance);
            this.getMascot().setAnchor(new Point(this.getMascot().getAnchor().x + velocityX, this.getMascot().getAnchor().y + velocityY));
            this.getAnimation().next(this.getMascot(), this.getTime());
        }
        if (distance <= velocity) {
            this.getMascot().setAnchor(new Point(targetX, targetY));
            try {
                this.getMascot().setBehavior(Main.getInstance().getConfiguration(this.getMascot().getImageSet()).buildBehavior(this.getBehavior(), this.getMascot()));
                ((Mascot)this.target.get()).setBehavior(Main.getInstance().getConfiguration(((Mascot)this.target.get()).getImageSet()).buildBehavior(this.getTargetBehavior(), (Mascot)this.target.get()));
                if (this.getTargetLook() && ((Mascot)this.target.get()).isLookRight() == this.getMascot().isLookRight()) {
                    ((Mascot)this.target.get()).setLookRight(!this.getMascot().isLookRight());
                }
            }
            catch (NullPointerException e) {
                log.log(Level.SEVERE, "Fatal Exception", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("FailedSetBehaviourErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
            }
            catch (BehaviorInstantiationException e) {
                log.log(Level.SEVERE, "Fatal Exception", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("FailedSetBehaviourErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "Fatal Exception", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("FailedSetBehaviourErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
            }
        }
    }

    private String getBehavior() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_BEHAVIOUR), String.class, "");
    }

    private String getTargetBehavior() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_TARGETBEHAVIOUR), String.class, "");
    }

    private boolean getTargetLook() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_TARGETLOOK), Boolean.class, false);
    }

    private double getVelocity() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_VELOCITY), Number.class, 20.0)).doubleValue();
    }
}

